// By EVOLVED
// www.evolved-software.com

//--------------
// un-tweaks
//--------------
   float4x4 World:World;
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 ViewInv:ViewInverse;
   float4x4 ViewProj:ViewProjection;
   float4x4 View:View;

//-------------
// tweaks
//--------------
   float4 ViewSize1;
   float4 ViewSize2;
   float4 ViewProjInv1;
   float4 ViewProjInv2;
   float4 ViewProjInv3;
   float4 ViewProjInv4;
   float4x4 ShadowProj1;
   float4x4 ShadowProj2;
   float4x4 ShadowProj3;
   float4x4 ShadowProj4;
   float3 ShadowPosition1;
   float3 ShadowPosition2;
   float3 ShadowPosition3;
   float3 ShadowPosition4;
   float3 ShadowDirection1;
   float3 ShadowDirection2;
   float3 ShadowDirection3;
   float3 ShadowDirection4;
   float4 ShadowRanges;
   float4 ShadowBlur={0.00195959178*0.5,0.00252982212*0.5,0.0029933259*0.5,0.00339411254*0.5};
   float4 ShadowNoise;

//--------------
// Textures
//--------------
   texture DepthTexture <string Name = " ";>;
   sampler DepthSampler=sampler_state 
      {
	Texture=<DepthTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture ShadowMap1Texture <string Name = " ";>;
   sampler ShadowMap1Sampler=sampler_state 
      {
	Texture=<ShadowMap1Texture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
	BorderColor=float4(255,255,255,255);
      };
   texture ShadowMap2Texture <string Name = " ";>;
   sampler ShadowMap2Sampler=sampler_state 
      {
	Texture=<ShadowMap2Texture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
	BorderColor=float4(255,255,255,255);
      };
   texture SSAOTexture <string Name = " ";>;
   sampler SSAOSampler=sampler_state 
      {
	Texture=<SSAOTexture>;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Tex:TEXCOORD0;
 	float2 ClipSpace:TEXCOORD1;
	float4 Tex1:TEXCOORD2;
	float4 Tex2:TEXCOORD3;
	float4 Tex3:TEXCOORD4;
	float4 Tex4:TEXCOORD5;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos;
	OUT.Tex=0;
 	OUT.Tex.xy=(float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5;
 	OUT.Tex=(OUT.Tex*ViewSize2)+ViewSize1;
	OUT.ClipSpace=float2(IN.Pos.x,-IN.Pos.y);
 	OUT.Tex1=OUT.Tex+float4(ViewSize1.x,ViewSize1.y,0.0,0.0)*6.0;
 	OUT.Tex2=OUT.Tex+float4(-ViewSize1.x,ViewSize1.y,0.0,0.0)*6.0;
 	OUT.Tex3=OUT.Tex+float4(ViewSize1.x,-ViewSize1.y,0.0,0.0)*6.0;
 	OUT.Tex4=OUT.Tex+float4(-ViewSize1.x,-ViewSize1.y,0.0,0.0)*6.0;
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float4x4 ViewProjInv=float4x4(ViewProjInv1,ViewProjInv2,ViewProjInv3,ViewProjInv4);
	float Depth=tex2Dlod(DepthSampler,IN.Tex);
	float4 WorldPos=mul(float4(IN.ClipSpace,Depth,1),ViewProjInv);
	WorldPos.xyz /=WorldPos.w;
	WorldPos.xyz +=normalize(cross(ddx(WorldPos.xyz),ddy(WorldPos.xyz)))*2;
	float2 ShadowDepth=float2(dot(WorldPos.xyz-ShadowPosition1,ShadowDirection1),dot(WorldPos.xyz-ShadowPosition2,ShadowDirection2))/ShadowRanges.xy;
      	float4 LightProj2=mul(float4(WorldPos.xyz,1),ShadowProj2)*float4(0.5,-0.5,0.0,0.0)+0.5004;
	float3 Cascade=floor(abs(float3(LightProj2.xy,ShadowDepth.y)*2.02-1.01));
 	float Shadows=0;
	if(Cascade.x+Cascade.y+Cascade.z>0.0) {
    	 float4 LightProj3=mul(float4(WorldPos.xyz,1),ShadowProj3)*float4(0.5,-0.5,0.0,0.0)+0.5004;
    	 float4 LightProj4=mul(float4(WorldPos.xyz,1),ShadowProj4)*float4(0.5,-0.5,0.0,0.0)+0.5004;
	 ShadowDepth=float2(dot(WorldPos.xyz-ShadowPosition3,ShadowDirection3),dot(WorldPos.xyz-ShadowPosition4,ShadowDirection4))/ShadowRanges.zw;
	 Cascade=floor(abs(float3(LightProj3.xy,ShadowDepth.y)*2.02-1.01));
	 Cascade.x=saturate(Cascade.x+Cascade.y+Cascade.x);
	 float2 ShadowMap=float2(tex2Dlod(ShadowMap2Sampler,LightProj3).x,tex2Dlod(ShadowMap2Sampler,LightProj4).y);   
	 Shadows=step(ShadowDepth[Cascade.x],ShadowMap[Cascade.x]);
	}
	else {
      	 float4 LightProj1=mul(float4(WorldPos.xyz,1),ShadowProj1)*float4(0.5,-0.5,0.0,0.0)+0.5004;
	 Cascade=floor(abs(float3(LightProj1.xy,ShadowDepth.y)*2.02-1.01));
	 Cascade.x=saturate(Cascade.x+Cascade.y+Cascade.x);
    	 float Noise=frac(52.9829*frac(dot(IN.Tex*ShadowNoise.xy,ShadowNoise.zw)));
	 float4 DiskSin=0, DiskCos=0;
	 sincos((Noise+float4(2,3,4,5))*2.4,DiskSin,DiskCos);
	 float4 Disk1=float4(DiskSin.x,DiskCos.x,DiskSin.y,DiskCos.y)*ShadowBlur.xxyy;
	 float4 Disk2=float4(DiskSin.z,DiskCos.z,DiskSin.w,DiskCos.w)*ShadowBlur.zzww;
	 float4 ShadowMap[2]={float4(tex2Dlod(ShadowMap1Sampler,LightProj1+Disk1.xyyy).x,tex2Dlod(ShadowMap1Sampler,LightProj1+Disk1.zwww).x,tex2Dlod(ShadowMap1Sampler,LightProj1+Disk2.xyyy).x,tex2Dlod(ShadowMap1Sampler,LightProj1+Disk2.zwww).x),
			      float4(tex2Dlod(ShadowMap1Sampler,LightProj2+Disk1.xyyy*0.5).yy,tex2Dlod(ShadowMap1Sampler,LightProj2+Disk1.zwww*0.5).yy)};   
	 Shadows=dot(step(ShadowDepth[Cascade.x].xxxx,ShadowMap[Cascade.x]),0.25);
	}
	float SSAO=tex2Dlod(SSAOSampler,IN.Tex1).w+tex2Dlod(SSAOSampler,IN.Tex2).w+tex2Dlod(SSAOSampler,IN.Tex3).w+tex2Dlod(SSAOSampler,IN.Tex4).w;
	return float4(0.0,lerp(SSAO*0.125,1.0,Shadows),0.0,0.0);
     }

//--------------
// techniques   
//--------------
    technique DirectionalLight
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS();
        ColorWriteEnable=2;
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }